/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDhcpOptionsRequest
extends BmcRequest {
    private String dhcpId;

    @ConstructorProperties(value={"dhcpId"})
    GetDhcpOptionsRequest(String dhcpId) {
        this.dhcpId = dhcpId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDhcpId() {
        return this.dhcpId;
    }

    public static class Builder {
        private String dhcpId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDhcpOptionsRequest o) {
            this.dhcpId(o.getDhcpId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDhcpOptionsRequest build() {
            GetDhcpOptionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dhcpId(String dhcpId) {
            this.dhcpId = dhcpId;
            return this;
        }

        public GetDhcpOptionsRequest buildWithoutInvocationCallback() {
            return new GetDhcpOptionsRequest(this.dhcpId);
        }

        public String toString() {
            return "GetDhcpOptionsRequest.Builder(dhcpId=" + this.dhcpId + ")";
        }
    }
}

