/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDrgRequest
extends BmcRequest {
    private String drgId;

    @ConstructorProperties(value={"drgId"})
    GetDrgRequest(String drgId) {
        this.drgId = drgId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDrgId() {
        return this.drgId;
    }

    public static class Builder {
        private String drgId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDrgRequest o) {
            this.drgId(o.getDrgId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDrgRequest build() {
            GetDrgRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            return this;
        }

        public GetDrgRequest buildWithoutInvocationCallback() {
            return new GetDrgRequest(this.drgId);
        }

        public String toString() {
            return "GetDrgRequest.Builder(drgId=" + this.drgId + ")";
        }
    }
}

