/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetFastConnectProviderServiceKeyRequest
extends BmcRequest {
    private String providerServiceId;
    private String providerServiceKeyName;

    @ConstructorProperties(value={"providerServiceId", "providerServiceKeyName"})
    GetFastConnectProviderServiceKeyRequest(String providerServiceId, String providerServiceKeyName) {
        this.providerServiceId = providerServiceId;
        this.providerServiceKeyName = providerServiceKeyName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getProviderServiceId() {
        return this.providerServiceId;
    }

    public String getProviderServiceKeyName() {
        return this.providerServiceKeyName;
    }

    public static class Builder {
        private String providerServiceId;
        private String providerServiceKeyName;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetFastConnectProviderServiceKeyRequest o) {
            this.providerServiceId(o.getProviderServiceId());
            this.providerServiceKeyName(o.getProviderServiceKeyName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetFastConnectProviderServiceKeyRequest build() {
            GetFastConnectProviderServiceKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder providerServiceId(String providerServiceId) {
            this.providerServiceId = providerServiceId;
            return this;
        }

        public Builder providerServiceKeyName(String providerServiceKeyName) {
            this.providerServiceKeyName = providerServiceKeyName;
            return this;
        }

        public GetFastConnectProviderServiceKeyRequest buildWithoutInvocationCallback() {
            return new GetFastConnectProviderServiceKeyRequest(this.providerServiceId, this.providerServiceKeyName);
        }

        public String toString() {
            return "GetFastConnectProviderServiceKeyRequest.Builder(providerServiceId=" + this.providerServiceId + ", providerServiceKeyName=" + this.providerServiceKeyName + ")";
        }
    }
}

