/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetFastConnectProviderServiceRequest
extends BmcRequest {
    private String providerServiceId;

    @ConstructorProperties(value={"providerServiceId"})
    GetFastConnectProviderServiceRequest(String providerServiceId) {
        this.providerServiceId = providerServiceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getProviderServiceId() {
        return this.providerServiceId;
    }

    public static class Builder {
        private String providerServiceId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetFastConnectProviderServiceRequest o) {
            this.providerServiceId(o.getProviderServiceId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetFastConnectProviderServiceRequest build() {
            GetFastConnectProviderServiceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder providerServiceId(String providerServiceId) {
            this.providerServiceId = providerServiceId;
            return this;
        }

        public GetFastConnectProviderServiceRequest buildWithoutInvocationCallback() {
            return new GetFastConnectProviderServiceRequest(this.providerServiceId);
        }

        public String toString() {
            return "GetFastConnectProviderServiceRequest.Builder(providerServiceId=" + this.providerServiceId + ")";
        }
    }
}

