/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetIPSecConnectionTunnelRequest
extends BmcRequest {
    private String ipscId;
    private String tunnelId;

    @ConstructorProperties(value={"ipscId", "tunnelId"})
    GetIPSecConnectionTunnelRequest(String ipscId, String tunnelId) {
        this.ipscId = ipscId;
        this.tunnelId = tunnelId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIpscId() {
        return this.ipscId;
    }

    public String getTunnelId() {
        return this.tunnelId;
    }

    public static class Builder {
        private String ipscId;
        private String tunnelId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIPSecConnectionTunnelRequest o) {
            this.ipscId(o.getIpscId());
            this.tunnelId(o.getTunnelId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIPSecConnectionTunnelRequest build() {
            GetIPSecConnectionTunnelRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder ipscId(String ipscId) {
            this.ipscId = ipscId;
            return this;
        }

        public Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public GetIPSecConnectionTunnelRequest buildWithoutInvocationCallback() {
            return new GetIPSecConnectionTunnelRequest(this.ipscId, this.tunnelId);
        }

        public String toString() {
            return "GetIPSecConnectionTunnelRequest.Builder(ipscId=" + this.ipscId + ", tunnelId=" + this.tunnelId + ")";
        }
    }
}

