/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetImageRequest
extends BmcRequest {
    private String imageId;

    @ConstructorProperties(value={"imageId"})
    GetImageRequest(String imageId) {
        this.imageId = imageId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getImageId() {
        return this.imageId;
    }

    public static class Builder {
        private String imageId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetImageRequest o) {
            this.imageId(o.getImageId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetImageRequest build() {
            GetImageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public GetImageRequest buildWithoutInvocationCallback() {
            return new GetImageRequest(this.imageId);
        }

        public String toString() {
            return "GetImageRequest.Builder(imageId=" + this.imageId + ")";
        }
    }
}

