/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetInstanceConfigurationRequest
extends BmcRequest {
    private String instanceConfigurationId;

    @ConstructorProperties(value={"instanceConfigurationId"})
    GetInstanceConfigurationRequest(String instanceConfigurationId) {
        this.instanceConfigurationId = instanceConfigurationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceConfigurationId() {
        return this.instanceConfigurationId;
    }

    public static class Builder {
        private String instanceConfigurationId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInstanceConfigurationRequest o) {
            this.instanceConfigurationId(o.getInstanceConfigurationId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInstanceConfigurationRequest build() {
            GetInstanceConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceConfigurationId(String instanceConfigurationId) {
            this.instanceConfigurationId = instanceConfigurationId;
            return this;
        }

        public GetInstanceConfigurationRequest buildWithoutInvocationCallback() {
            return new GetInstanceConfigurationRequest(this.instanceConfigurationId);
        }

        public String toString() {
            return "GetInstanceConfigurationRequest.Builder(instanceConfigurationId=" + this.instanceConfigurationId + ")";
        }
    }
}

