/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetInstanceConsoleConnectionRequest
extends BmcRequest {
    private String instanceConsoleConnectionId;

    @ConstructorProperties(value={"instanceConsoleConnectionId"})
    GetInstanceConsoleConnectionRequest(String instanceConsoleConnectionId) {
        this.instanceConsoleConnectionId = instanceConsoleConnectionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceConsoleConnectionId() {
        return this.instanceConsoleConnectionId;
    }

    public static class Builder {
        private String instanceConsoleConnectionId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInstanceConsoleConnectionRequest o) {
            this.instanceConsoleConnectionId(o.getInstanceConsoleConnectionId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInstanceConsoleConnectionRequest build() {
            GetInstanceConsoleConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceConsoleConnectionId(String instanceConsoleConnectionId) {
            this.instanceConsoleConnectionId = instanceConsoleConnectionId;
            return this;
        }

        public GetInstanceConsoleConnectionRequest buildWithoutInvocationCallback() {
            return new GetInstanceConsoleConnectionRequest(this.instanceConsoleConnectionId);
        }

        public String toString() {
            return "GetInstanceConsoleConnectionRequest.Builder(instanceConsoleConnectionId=" + this.instanceConsoleConnectionId + ")";
        }
    }
}

