/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetInstancePoolLoadBalancerAttachmentRequest
extends BmcRequest {
    private String instancePoolId;
    private String instancePoolLoadBalancerAttachmentId;

    @ConstructorProperties(value={"instancePoolId", "instancePoolLoadBalancerAttachmentId"})
    GetInstancePoolLoadBalancerAttachmentRequest(String instancePoolId, String instancePoolLoadBalancerAttachmentId) {
        this.instancePoolId = instancePoolId;
        this.instancePoolLoadBalancerAttachmentId = instancePoolLoadBalancerAttachmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstancePoolId() {
        return this.instancePoolId;
    }

    public String getInstancePoolLoadBalancerAttachmentId() {
        return this.instancePoolLoadBalancerAttachmentId;
    }

    public static class Builder {
        private String instancePoolId;
        private String instancePoolLoadBalancerAttachmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInstancePoolLoadBalancerAttachmentRequest o) {
            this.instancePoolId(o.getInstancePoolId());
            this.instancePoolLoadBalancerAttachmentId(o.getInstancePoolLoadBalancerAttachmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInstancePoolLoadBalancerAttachmentRequest build() {
            GetInstancePoolLoadBalancerAttachmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instancePoolId(String instancePoolId) {
            this.instancePoolId = instancePoolId;
            return this;
        }

        public Builder instancePoolLoadBalancerAttachmentId(String instancePoolLoadBalancerAttachmentId) {
            this.instancePoolLoadBalancerAttachmentId = instancePoolLoadBalancerAttachmentId;
            return this;
        }

        public GetInstancePoolLoadBalancerAttachmentRequest buildWithoutInvocationCallback() {
            return new GetInstancePoolLoadBalancerAttachmentRequest(this.instancePoolId, this.instancePoolLoadBalancerAttachmentId);
        }

        public String toString() {
            return "GetInstancePoolLoadBalancerAttachmentRequest.Builder(instancePoolId=" + this.instancePoolId + ", instancePoolLoadBalancerAttachmentId=" + this.instancePoolLoadBalancerAttachmentId + ")";
        }
    }
}

