/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPrivateIpRequest
extends BmcRequest {
    private String privateIpId;

    @ConstructorProperties(value={"privateIpId"})
    GetPrivateIpRequest(String privateIpId) {
        this.privateIpId = privateIpId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPrivateIpId() {
        return this.privateIpId;
    }

    public static class Builder {
        private String privateIpId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPrivateIpRequest o) {
            this.privateIpId(o.getPrivateIpId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPrivateIpRequest build() {
            GetPrivateIpRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder privateIpId(String privateIpId) {
            this.privateIpId = privateIpId;
            return this;
        }

        public GetPrivateIpRequest buildWithoutInvocationCallback() {
            return new GetPrivateIpRequest(this.privateIpId);
        }

        public String toString() {
            return "GetPrivateIpRequest.Builder(privateIpId=" + this.privateIpId + ")";
        }
    }
}

