/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetPublicIpRequest
extends BmcRequest {
    private String publicIpId;

    @ConstructorProperties(value={"publicIpId"})
    GetPublicIpRequest(String publicIpId) {
        this.publicIpId = publicIpId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPublicIpId() {
        return this.publicIpId;
    }

    public static class Builder {
        private String publicIpId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPublicIpRequest o) {
            this.publicIpId(o.getPublicIpId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPublicIpRequest build() {
            GetPublicIpRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder publicIpId(String publicIpId) {
            this.publicIpId = publicIpId;
            return this;
        }

        public GetPublicIpRequest buildWithoutInvocationCallback() {
            return new GetPublicIpRequest(this.publicIpId);
        }

        public String toString() {
            return "GetPublicIpRequest.Builder(publicIpId=" + this.publicIpId + ")";
        }
    }
}

