/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetRouteTableRequest
extends BmcRequest {
    private String rtId;

    @ConstructorProperties(value={"rtId"})
    GetRouteTableRequest(String rtId) {
        this.rtId = rtId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRtId() {
        return this.rtId;
    }

    public static class Builder {
        private String rtId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRouteTableRequest o) {
            this.rtId(o.getRtId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRouteTableRequest build() {
            GetRouteTableRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder rtId(String rtId) {
            this.rtId = rtId;
            return this;
        }

        public GetRouteTableRequest buildWithoutInvocationCallback() {
            return new GetRouteTableRequest(this.rtId);
        }

        public String toString() {
            return "GetRouteTableRequest.Builder(rtId=" + this.rtId + ")";
        }
    }
}

