/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetSecurityListRequest
extends BmcRequest {
    private String securityListId;

    @ConstructorProperties(value={"securityListId"})
    GetSecurityListRequest(String securityListId) {
        this.securityListId = securityListId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSecurityListId() {
        return this.securityListId;
    }

    public static class Builder {
        private String securityListId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSecurityListRequest o) {
            this.securityListId(o.getSecurityListId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSecurityListRequest build() {
            GetSecurityListRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder securityListId(String securityListId) {
            this.securityListId = securityListId;
            return this;
        }

        public GetSecurityListRequest buildWithoutInvocationCallback() {
            return new GetSecurityListRequest(this.securityListId);
        }

        public String toString() {
            return "GetSecurityListRequest.Builder(securityListId=" + this.securityListId + ")";
        }
    }
}

