/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetServiceGatewayRequest
extends BmcRequest {
    private String serviceGatewayId;

    @ConstructorProperties(value={"serviceGatewayId"})
    GetServiceGatewayRequest(String serviceGatewayId) {
        this.serviceGatewayId = serviceGatewayId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getServiceGatewayId() {
        return this.serviceGatewayId;
    }

    public static class Builder {
        private String serviceGatewayId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetServiceGatewayRequest o) {
            this.serviceGatewayId(o.getServiceGatewayId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetServiceGatewayRequest build() {
            GetServiceGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder serviceGatewayId(String serviceGatewayId) {
            this.serviceGatewayId = serviceGatewayId;
            return this;
        }

        public GetServiceGatewayRequest buildWithoutInvocationCallback() {
            return new GetServiceGatewayRequest(this.serviceGatewayId);
        }

        public String toString() {
            return "GetServiceGatewayRequest.Builder(serviceGatewayId=" + this.serviceGatewayId + ")";
        }
    }
}

