/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetServiceRequest
extends BmcRequest {
    private String serviceId;

    @ConstructorProperties(value={"serviceId"})
    GetServiceRequest(String serviceId) {
        this.serviceId = serviceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public static class Builder {
        private String serviceId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetServiceRequest o) {
            this.serviceId(o.getServiceId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetServiceRequest build() {
            GetServiceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public GetServiceRequest buildWithoutInvocationCallback() {
            return new GetServiceRequest(this.serviceId);
        }

        public String toString() {
            return "GetServiceRequest.Builder(serviceId=" + this.serviceId + ")";
        }
    }
}

