/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetVcnRequest
extends BmcRequest {
    private String vcnId;

    @ConstructorProperties(value={"vcnId"})
    GetVcnRequest(String vcnId) {
        this.vcnId = vcnId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public static class Builder {
        private String vcnId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVcnRequest o) {
            this.vcnId(o.getVcnId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVcnRequest build() {
            GetVcnRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            return this;
        }

        public GetVcnRequest buildWithoutInvocationCallback() {
            return new GetVcnRequest(this.vcnId);
        }

        public String toString() {
            return "GetVcnRequest.Builder(vcnId=" + this.vcnId + ")";
        }
    }
}

