/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetVirtualCircuitRequest
extends BmcRequest {
    private String virtualCircuitId;

    @ConstructorProperties(value={"virtualCircuitId"})
    GetVirtualCircuitRequest(String virtualCircuitId) {
        this.virtualCircuitId = virtualCircuitId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVirtualCircuitId() {
        return this.virtualCircuitId;
    }

    public static class Builder {
        private String virtualCircuitId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVirtualCircuitRequest o) {
            this.virtualCircuitId(o.getVirtualCircuitId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVirtualCircuitRequest build() {
            GetVirtualCircuitRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder virtualCircuitId(String virtualCircuitId) {
            this.virtualCircuitId = virtualCircuitId;
            return this;
        }

        public GetVirtualCircuitRequest buildWithoutInvocationCallback() {
            return new GetVirtualCircuitRequest(this.virtualCircuitId);
        }

        public String toString() {
            return "GetVirtualCircuitRequest.Builder(virtualCircuitId=" + this.virtualCircuitId + ")";
        }
    }
}

