/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetVnicRequest
extends BmcRequest {
    private String vnicId;

    @ConstructorProperties(value={"vnicId"})
    GetVnicRequest(String vnicId) {
        this.vnicId = vnicId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVnicId() {
        return this.vnicId;
    }

    public static class Builder {
        private String vnicId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVnicRequest o) {
            this.vnicId(o.getVnicId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVnicRequest build() {
            GetVnicRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            return this;
        }

        public GetVnicRequest buildWithoutInvocationCallback() {
            return new GetVnicRequest(this.vnicId);
        }

        public String toString() {
            return "GetVnicRequest.Builder(vnicId=" + this.vnicId + ")";
        }
    }
}

