/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetVolumeBackupPolicyAssetAssignmentRequest
extends BmcRequest {
    private String assetId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"assetId", "limit", "page"})
    GetVolumeBackupPolicyAssetAssignmentRequest(String assetId, Integer limit, String page) {
        this.assetId = assetId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAssetId() {
        return this.assetId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder {
        private String assetId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVolumeBackupPolicyAssetAssignmentRequest o) {
            this.assetId(o.getAssetId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVolumeBackupPolicyAssetAssignmentRequest build() {
            GetVolumeBackupPolicyAssetAssignmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public GetVolumeBackupPolicyAssetAssignmentRequest buildWithoutInvocationCallback() {
            return new GetVolumeBackupPolicyAssetAssignmentRequest(this.assetId, this.limit, this.page);
        }

        public String toString() {
            return "GetVolumeBackupPolicyAssetAssignmentRequest.Builder(assetId=" + this.assetId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

