/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetVolumeBackupPolicyRequest
extends BmcRequest {
    private String policyId;

    @ConstructorProperties(value={"policyId"})
    GetVolumeBackupPolicyRequest(String policyId) {
        this.policyId = policyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public static class Builder {
        private String policyId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVolumeBackupPolicyRequest o) {
            this.policyId(o.getPolicyId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVolumeBackupPolicyRequest build() {
            GetVolumeBackupPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public GetVolumeBackupPolicyRequest buildWithoutInvocationCallback() {
            return new GetVolumeBackupPolicyRequest(this.policyId);
        }

        public String toString() {
            return "GetVolumeBackupPolicyRequest.Builder(policyId=" + this.policyId + ")";
        }
    }
}

