/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetVolumeBackupRequest
extends BmcRequest {
    private String volumeBackupId;

    @ConstructorProperties(value={"volumeBackupId"})
    GetVolumeBackupRequest(String volumeBackupId) {
        this.volumeBackupId = volumeBackupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVolumeBackupId() {
        return this.volumeBackupId;
    }

    public static class Builder {
        private String volumeBackupId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVolumeBackupRequest o) {
            this.volumeBackupId(o.getVolumeBackupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVolumeBackupRequest build() {
            GetVolumeBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder volumeBackupId(String volumeBackupId) {
            this.volumeBackupId = volumeBackupId;
            return this;
        }

        public GetVolumeBackupRequest buildWithoutInvocationCallback() {
            return new GetVolumeBackupRequest(this.volumeBackupId);
        }

        public String toString() {
            return "GetVolumeBackupRequest.Builder(volumeBackupId=" + this.volumeBackupId + ")";
        }
    }
}

