/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetVolumeGroupRequest
extends BmcRequest {
    private String volumeGroupId;

    @ConstructorProperties(value={"volumeGroupId"})
    GetVolumeGroupRequest(String volumeGroupId) {
        this.volumeGroupId = volumeGroupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVolumeGroupId() {
        return this.volumeGroupId;
    }

    public static class Builder {
        private String volumeGroupId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVolumeGroupRequest o) {
            this.volumeGroupId(o.getVolumeGroupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVolumeGroupRequest build() {
            GetVolumeGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder volumeGroupId(String volumeGroupId) {
            this.volumeGroupId = volumeGroupId;
            return this;
        }

        public GetVolumeGroupRequest buildWithoutInvocationCallback() {
            return new GetVolumeGroupRequest(this.volumeGroupId);
        }

        public String toString() {
            return "GetVolumeGroupRequest.Builder(volumeGroupId=" + this.volumeGroupId + ")";
        }
    }
}

