/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetVolumeRequest
extends BmcRequest {
    private String volumeId;

    @ConstructorProperties(value={"volumeId"})
    GetVolumeRequest(String volumeId) {
        this.volumeId = volumeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public static class Builder {
        private String volumeId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVolumeRequest o) {
            this.volumeId(o.getVolumeId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVolumeRequest build() {
            GetVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public GetVolumeRequest buildWithoutInvocationCallback() {
            return new GetVolumeRequest(this.volumeId);
        }

        public String toString() {
            return "GetVolumeRequest.Builder(volumeId=" + this.volumeId + ")";
        }
    }
}

