/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetWindowsInstanceInitialCredentialsRequest
extends BmcRequest {
    private String instanceId;

    @ConstructorProperties(value={"instanceId"})
    GetWindowsInstanceInitialCredentialsRequest(String instanceId) {
        this.instanceId = instanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public static class Builder {
        private String instanceId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetWindowsInstanceInitialCredentialsRequest o) {
            this.instanceId(o.getInstanceId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetWindowsInstanceInitialCredentialsRequest build() {
            GetWindowsInstanceInitialCredentialsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public GetWindowsInstanceInitialCredentialsRequest buildWithoutInvocationCallback() {
            return new GetWindowsInstanceInitialCredentialsRequest(this.instanceId);
        }

        public String toString() {
            return "GetWindowsInstanceInitialCredentialsRequest.Builder(instanceId=" + this.instanceId + ")";
        }
    }
}

