/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class InstanceActionRequest
extends BmcRequest {
    private String instanceId;
    private String action;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"instanceId", "action", "opcRetryToken", "ifMatch"})
    InstanceActionRequest(String instanceId, String action, String opcRetryToken, String ifMatch) {
        this.instanceId = instanceId;
        this.action = action;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getAction() {
        return this.action;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String instanceId;
        private String action;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(InstanceActionRequest o) {
            this.instanceId(o.getInstanceId());
            this.action(o.getAction());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public InstanceActionRequest build() {
            InstanceActionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public InstanceActionRequest buildWithoutInvocationCallback() {
            return new InstanceActionRequest(this.instanceId, this.action, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "InstanceActionRequest.Builder(instanceId=" + this.instanceId + ", action=" + this.action + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

