/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.InstanceConfigurationInstanceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class LaunchInstanceConfigurationRequest
extends BmcRequest {
    private String instanceConfigurationId;
    private InstanceConfigurationInstanceDetails instanceConfiguration;
    private String opcRetryToken;

    @ConstructorProperties(value={"instanceConfigurationId", "instanceConfiguration", "opcRetryToken"})
    LaunchInstanceConfigurationRequest(String instanceConfigurationId, InstanceConfigurationInstanceDetails instanceConfiguration, String opcRetryToken) {
        this.instanceConfigurationId = instanceConfigurationId;
        this.instanceConfiguration = instanceConfiguration;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceConfigurationId() {
        return this.instanceConfigurationId;
    }

    public InstanceConfigurationInstanceDetails getInstanceConfiguration() {
        return this.instanceConfiguration;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private String instanceConfigurationId;
        private InstanceConfigurationInstanceDetails instanceConfiguration;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(LaunchInstanceConfigurationRequest o) {
            this.instanceConfigurationId(o.getInstanceConfigurationId());
            this.instanceConfiguration(o.getInstanceConfiguration());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public LaunchInstanceConfigurationRequest build() {
            LaunchInstanceConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceConfigurationId(String instanceConfigurationId) {
            this.instanceConfigurationId = instanceConfigurationId;
            return this;
        }

        public Builder instanceConfiguration(InstanceConfigurationInstanceDetails instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public LaunchInstanceConfigurationRequest buildWithoutInvocationCallback() {
            return new LaunchInstanceConfigurationRequest(this.instanceConfigurationId, this.instanceConfiguration, this.opcRetryToken);
        }

        public String toString() {
            return "LaunchInstanceConfigurationRequest.Builder(instanceConfigurationId=" + this.instanceConfigurationId + ", instanceConfiguration=" + this.instanceConfiguration + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

