/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.LaunchInstanceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class LaunchInstanceRequest
extends BmcRequest {
    private LaunchInstanceDetails launchInstanceDetails;
    private String opcRetryToken;

    @ConstructorProperties(value={"launchInstanceDetails", "opcRetryToken"})
    LaunchInstanceRequest(LaunchInstanceDetails launchInstanceDetails, String opcRetryToken) {
        this.launchInstanceDetails = launchInstanceDetails;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LaunchInstanceDetails getLaunchInstanceDetails() {
        return this.launchInstanceDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private LaunchInstanceDetails launchInstanceDetails;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(LaunchInstanceRequest o) {
            this.launchInstanceDetails(o.getLaunchInstanceDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public LaunchInstanceRequest build() {
            LaunchInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder launchInstanceDetails(LaunchInstanceDetails launchInstanceDetails) {
            this.launchInstanceDetails = launchInstanceDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public LaunchInstanceRequest buildWithoutInvocationCallback() {
            return new LaunchInstanceRequest(this.launchInstanceDetails, this.opcRetryToken);
        }

        public String toString() {
            return "LaunchInstanceRequest.Builder(launchInstanceDetails=" + this.launchInstanceDetails + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

