/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListAppCatalogListingResourceVersionsRequest
extends BmcRequest {
    private String listingId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"listingId", "limit", "page", "sortOrder"})
    ListAppCatalogListingResourceVersionsRequest(String listingId, Integer limit, String page, SortOrder sortOrder) {
        this.listingId = listingId;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getListingId() {
        return this.listingId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder {
        private String listingId;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAppCatalogListingResourceVersionsRequest o) {
            this.listingId(o.getListingId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAppCatalogListingResourceVersionsRequest build() {
            ListAppCatalogListingResourceVersionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListAppCatalogListingResourceVersionsRequest buildWithoutInvocationCallback() {
            return new ListAppCatalogListingResourceVersionsRequest(this.listingId, this.limit, this.page, this.sortOrder);
        }

        public String toString() {
            return "ListAppCatalogListingResourceVersionsRequest.Builder(listingId=" + this.listingId + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

