/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListAppCatalogListingsRequest
extends BmcRequest {
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private String publisherName;
    private String publisherType;
    private String displayName;

    @ConstructorProperties(value={"limit", "page", "sortOrder", "publisherName", "publisherType", "displayName"})
    ListAppCatalogListingsRequest(Integer limit, String page, SortOrder sortOrder, String publisherName, String publisherType, String displayName) {
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.publisherName = publisherName;
        this.publisherType = publisherType;
        this.displayName = displayName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public String getPublisherType() {
        return this.publisherType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static class Builder {
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private String publisherName;
        private String publisherType;
        private String displayName;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAppCatalogListingsRequest o) {
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.publisherName(o.getPublisherName());
            this.publisherType(o.getPublisherType());
            this.displayName(o.getDisplayName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAppCatalogListingsRequest build() {
            ListAppCatalogListingsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            return this;
        }

        public Builder publisherType(String publisherType) {
            this.publisherType = publisherType;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ListAppCatalogListingsRequest buildWithoutInvocationCallback() {
            return new ListAppCatalogListingsRequest(this.limit, this.page, this.sortOrder, this.publisherName, this.publisherType, this.displayName);
        }

        public String toString() {
            return "ListAppCatalogListingsRequest.Builder(limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", publisherName=" + this.publisherName + ", publisherType=" + this.publisherType + ", displayName=" + this.displayName + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

