/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListBootVolumesRequest
extends BmcRequest {
    private String availabilityDomain;
    private String compartmentId;
    private Integer limit;
    private String page;
    private String volumeGroupId;

    @ConstructorProperties(value={"availabilityDomain", "compartmentId", "limit", "page", "volumeGroupId"})
    ListBootVolumesRequest(String availabilityDomain, String compartmentId, Integer limit, String page, String volumeGroupId) {
        this.availabilityDomain = availabilityDomain;
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.volumeGroupId = volumeGroupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getVolumeGroupId() {
        return this.volumeGroupId;
    }

    public static class Builder {
        private String availabilityDomain;
        private String compartmentId;
        private Integer limit;
        private String page;
        private String volumeGroupId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListBootVolumesRequest o) {
            this.availabilityDomain(o.getAvailabilityDomain());
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.volumeGroupId(o.getVolumeGroupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListBootVolumesRequest build() {
            ListBootVolumesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder volumeGroupId(String volumeGroupId) {
            this.volumeGroupId = volumeGroupId;
            return this;
        }

        public ListBootVolumesRequest buildWithoutInvocationCallback() {
            return new ListBootVolumesRequest(this.availabilityDomain, this.compartmentId, this.limit, this.page, this.volumeGroupId);
        }

        public String toString() {
            return "ListBootVolumesRequest.Builder(availabilityDomain=" + this.availabilityDomain + ", compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", volumeGroupId=" + this.volumeGroupId + ")";
        }
    }
}

