/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListDrgAttachmentsRequest
extends BmcRequest {
    private String compartmentId;
    private String vcnId;
    private String drgId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"compartmentId", "vcnId", "drgId", "limit", "page"})
    ListDrgAttachmentsRequest(String compartmentId, String vcnId, String drgId, Integer limit, String page) {
        this.compartmentId = compartmentId;
        this.vcnId = vcnId;
        this.drgId = drgId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public String getDrgId() {
        return this.drgId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder {
        private String compartmentId;
        private String vcnId;
        private String drgId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDrgAttachmentsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.vcnId(o.getVcnId());
            this.drgId(o.getDrgId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDrgAttachmentsRequest build() {
            ListDrgAttachmentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            return this;
        }

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListDrgAttachmentsRequest buildWithoutInvocationCallback() {
            return new ListDrgAttachmentsRequest(this.compartmentId, this.vcnId, this.drgId, this.limit, this.page);
        }

        public String toString() {
            return "ListDrgAttachmentsRequest.Builder(compartmentId=" + this.compartmentId + ", vcnId=" + this.vcnId + ", drgId=" + this.drgId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

