/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListIPSecConnectionTunnelsRequest
extends BmcRequest {
    private String ipscId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"ipscId", "limit", "page"})
    ListIPSecConnectionTunnelsRequest(String ipscId, Integer limit, String page) {
        this.ipscId = ipscId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIpscId() {
        return this.ipscId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder {
        private String ipscId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIPSecConnectionTunnelsRequest o) {
            this.ipscId(o.getIpscId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIPSecConnectionTunnelsRequest build() {
            ListIPSecConnectionTunnelsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder ipscId(String ipscId) {
            this.ipscId = ipscId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListIPSecConnectionTunnelsRequest buildWithoutInvocationCallback() {
            return new ListIPSecConnectionTunnelsRequest(this.ipscId, this.limit, this.page);
        }

        public String toString() {
            return "ListIPSecConnectionTunnelsRequest.Builder(ipscId=" + this.ipscId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

