/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListIPSecConnectionsRequest
extends BmcRequest {
    private String compartmentId;
    private String drgId;
    private String cpeId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"compartmentId", "drgId", "cpeId", "limit", "page"})
    ListIPSecConnectionsRequest(String compartmentId, String drgId, String cpeId, Integer limit, String page) {
        this.compartmentId = compartmentId;
        this.drgId = drgId;
        this.cpeId = cpeId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDrgId() {
        return this.drgId;
    }

    public String getCpeId() {
        return this.cpeId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder {
        private String compartmentId;
        private String drgId;
        private String cpeId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIPSecConnectionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.drgId(o.getDrgId());
            this.cpeId(o.getCpeId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIPSecConnectionsRequest build() {
            ListIPSecConnectionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            return this;
        }

        public Builder cpeId(String cpeId) {
            this.cpeId = cpeId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListIPSecConnectionsRequest buildWithoutInvocationCallback() {
            return new ListIPSecConnectionsRequest(this.compartmentId, this.drgId, this.cpeId, this.limit, this.page);
        }

        public String toString() {
            return "ListIPSecConnectionsRequest.Builder(compartmentId=" + this.compartmentId + ", drgId=" + this.drgId + ", cpeId=" + this.cpeId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

