/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListInstanceConsoleConnectionsRequest
extends BmcRequest {
    private String compartmentId;
    private String instanceId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"compartmentId", "instanceId", "limit", "page"})
    ListInstanceConsoleConnectionsRequest(String compartmentId, String instanceId, Integer limit, String page) {
        this.compartmentId = compartmentId;
        this.instanceId = instanceId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder {
        private String compartmentId;
        private String instanceId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListInstanceConsoleConnectionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.instanceId(o.getInstanceId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListInstanceConsoleConnectionsRequest build() {
            ListInstanceConsoleConnectionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListInstanceConsoleConnectionsRequest buildWithoutInvocationCallback() {
            return new ListInstanceConsoleConnectionsRequest(this.compartmentId, this.instanceId, this.limit, this.page);
        }

        public String toString() {
            return "ListInstanceConsoleConnectionsRequest.Builder(compartmentId=" + this.compartmentId + ", instanceId=" + this.instanceId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

