/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListPrivateIpsRequest
extends BmcRequest {
    private Integer limit;
    private String page;
    private String ipAddress;
    private String subnetId;
    private String vnicId;

    @ConstructorProperties(value={"limit", "page", "ipAddress", "subnetId", "vnicId"})
    ListPrivateIpsRequest(Integer limit, String page, String ipAddress, String subnetId, String vnicId) {
        this.limit = limit;
        this.page = page;
        this.ipAddress = ipAddress;
        this.subnetId = subnetId;
        this.vnicId = vnicId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getVnicId() {
        return this.vnicId;
    }

    public static class Builder {
        private Integer limit;
        private String page;
        private String ipAddress;
        private String subnetId;
        private String vnicId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPrivateIpsRequest o) {
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.ipAddress(o.getIpAddress());
            this.subnetId(o.getSubnetId());
            this.vnicId(o.getVnicId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPrivateIpsRequest build() {
            ListPrivateIpsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            return this;
        }

        public ListPrivateIpsRequest buildWithoutInvocationCallback() {
            return new ListPrivateIpsRequest(this.limit, this.page, this.ipAddress, this.subnetId, this.vnicId);
        }

        public String toString() {
            return "ListPrivateIpsRequest.Builder(limit=" + this.limit + ", page=" + this.page + ", ipAddress=" + this.ipAddress + ", subnetId=" + this.subnetId + ", vnicId=" + this.vnicId + ")";
        }
    }
}

