/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListPublicIpsRequest
extends BmcRequest {
    private Scope scope;
    private String compartmentId;
    private Integer limit;
    private String page;
    private String availabilityDomain;
    private Lifetime lifetime;

    @ConstructorProperties(value={"scope", "compartmentId", "limit", "page", "availabilityDomain", "lifetime"})
    ListPublicIpsRequest(Scope scope, String compartmentId, Integer limit, String page, String availabilityDomain, Lifetime lifetime) {
        this.scope = scope;
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.availabilityDomain = availabilityDomain;
        this.lifetime = lifetime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public static class Builder {
        private Scope scope;
        private String compartmentId;
        private Integer limit;
        private String page;
        private String availabilityDomain;
        private Lifetime lifetime;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPublicIpsRequest o) {
            this.scope(o.getScope());
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.lifetime(o.getLifetime());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPublicIpsRequest build() {
            ListPublicIpsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder lifetime(Lifetime lifetime) {
            this.lifetime = lifetime;
            return this;
        }

        public ListPublicIpsRequest buildWithoutInvocationCallback() {
            return new ListPublicIpsRequest(this.scope, this.compartmentId, this.limit, this.page, this.availabilityDomain, this.lifetime);
        }

        public String toString() {
            return "ListPublicIpsRequest.Builder(scope=" + (Object)((Object)this.scope) + ", compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", availabilityDomain=" + this.availabilityDomain + ", lifetime=" + (Object)((Object)this.lifetime) + ")";
        }
    }

    public static enum Lifetime {
        Ephemeral("EPHEMERAL"),
        Reserved("RESERVED");

        private final String value;
        private static Map<String, Lifetime> map;

        private Lifetime(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Lifetime create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid Lifetime: " + key);
        }

        static {
            map = new HashMap<String, Lifetime>();
            for (Lifetime v : Lifetime.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Scope {
        Region("REGION"),
        AvailabilityDomain("AVAILABILITY_DOMAIN");

        private final String value;
        private static Map<String, Scope> map;

        private Scope(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Scope create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid Scope: " + key);
        }

        static {
            map = new HashMap<String, Scope>();
            for (Scope v : Scope.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

