/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListShapesRequest
extends BmcRequest {
    private String compartmentId;
    private String availabilityDomain;
    private Integer limit;
    private String page;
    private String imageId;

    @ConstructorProperties(value={"compartmentId", "availabilityDomain", "limit", "page", "imageId"})
    ListShapesRequest(String compartmentId, String availabilityDomain, Integer limit, String page, String imageId) {
        this.compartmentId = compartmentId;
        this.availabilityDomain = availabilityDomain;
        this.limit = limit;
        this.page = page;
        this.imageId = imageId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getImageId() {
        return this.imageId;
    }

    public static class Builder {
        private String compartmentId;
        private String availabilityDomain;
        private Integer limit;
        private String page;
        private String imageId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListShapesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.imageId(o.getImageId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListShapesRequest build() {
            ListShapesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public ListShapesRequest buildWithoutInvocationCallback() {
            return new ListShapesRequest(this.compartmentId, this.availabilityDomain, this.limit, this.page, this.imageId);
        }

        public String toString() {
            return "ListShapesRequest.Builder(compartmentId=" + this.compartmentId + ", availabilityDomain=" + this.availabilityDomain + ", limit=" + this.limit + ", page=" + this.page + ", imageId=" + this.imageId + ")";
        }
    }
}

