/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.VirtualCircuitPublicPrefix;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListVirtualCircuitPublicPrefixesRequest
extends BmcRequest {
    private String virtualCircuitId;
    private VirtualCircuitPublicPrefix.VerificationState verificationState;

    @ConstructorProperties(value={"virtualCircuitId", "verificationState"})
    ListVirtualCircuitPublicPrefixesRequest(String virtualCircuitId, VirtualCircuitPublicPrefix.VerificationState verificationState) {
        this.virtualCircuitId = virtualCircuitId;
        this.verificationState = verificationState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVirtualCircuitId() {
        return this.virtualCircuitId;
    }

    public VirtualCircuitPublicPrefix.VerificationState getVerificationState() {
        return this.verificationState;
    }

    public static class Builder {
        private String virtualCircuitId;
        private VirtualCircuitPublicPrefix.VerificationState verificationState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListVirtualCircuitPublicPrefixesRequest o) {
            this.virtualCircuitId(o.getVirtualCircuitId());
            this.verificationState(o.getVerificationState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListVirtualCircuitPublicPrefixesRequest build() {
            ListVirtualCircuitPublicPrefixesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder virtualCircuitId(String virtualCircuitId) {
            this.virtualCircuitId = virtualCircuitId;
            return this;
        }

        public Builder verificationState(VirtualCircuitPublicPrefix.VerificationState verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        public ListVirtualCircuitPublicPrefixesRequest buildWithoutInvocationCallback() {
            return new ListVirtualCircuitPublicPrefixesRequest(this.virtualCircuitId, this.verificationState);
        }

        public String toString() {
            return "ListVirtualCircuitPublicPrefixesRequest.Builder(virtualCircuitId=" + this.virtualCircuitId + ", verificationState=" + (Object)((Object)this.verificationState) + ")";
        }
    }
}

