/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListVnicAttachmentsRequest
extends BmcRequest {
    private String compartmentId;
    private String availabilityDomain;
    private String instanceId;
    private Integer limit;
    private String page;
    private String vnicId;

    @ConstructorProperties(value={"compartmentId", "availabilityDomain", "instanceId", "limit", "page", "vnicId"})
    ListVnicAttachmentsRequest(String compartmentId, String availabilityDomain, String instanceId, Integer limit, String page, String vnicId) {
        this.compartmentId = compartmentId;
        this.availabilityDomain = availabilityDomain;
        this.instanceId = instanceId;
        this.limit = limit;
        this.page = page;
        this.vnicId = vnicId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getVnicId() {
        return this.vnicId;
    }

    public static class Builder {
        private String compartmentId;
        private String availabilityDomain;
        private String instanceId;
        private Integer limit;
        private String page;
        private String vnicId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListVnicAttachmentsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.instanceId(o.getInstanceId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.vnicId(o.getVnicId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListVnicAttachmentsRequest build() {
            ListVnicAttachmentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            return this;
        }

        public ListVnicAttachmentsRequest buildWithoutInvocationCallback() {
            return new ListVnicAttachmentsRequest(this.compartmentId, this.availabilityDomain, this.instanceId, this.limit, this.page, this.vnicId);
        }

        public String toString() {
            return "ListVnicAttachmentsRequest.Builder(compartmentId=" + this.compartmentId + ", availabilityDomain=" + this.availabilityDomain + ", instanceId=" + this.instanceId + ", limit=" + this.limit + ", page=" + this.page + ", vnicId=" + this.vnicId + ")";
        }
    }
}

