/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListVolumeAttachmentsRequest
extends BmcRequest {
    private String compartmentId;
    private String availabilityDomain;
    private Integer limit;
    private String page;
    private String instanceId;
    private String volumeId;

    @ConstructorProperties(value={"compartmentId", "availabilityDomain", "limit", "page", "instanceId", "volumeId"})
    ListVolumeAttachmentsRequest(String compartmentId, String availabilityDomain, Integer limit, String page, String instanceId, String volumeId) {
        this.compartmentId = compartmentId;
        this.availabilityDomain = availabilityDomain;
        this.limit = limit;
        this.page = page;
        this.instanceId = instanceId;
        this.volumeId = volumeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public static class Builder {
        private String compartmentId;
        private String availabilityDomain;
        private Integer limit;
        private String page;
        private String instanceId;
        private String volumeId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListVolumeAttachmentsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.instanceId(o.getInstanceId());
            this.volumeId(o.getVolumeId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListVolumeAttachmentsRequest build() {
            ListVolumeAttachmentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public ListVolumeAttachmentsRequest buildWithoutInvocationCallback() {
            return new ListVolumeAttachmentsRequest(this.compartmentId, this.availabilityDomain, this.limit, this.page, this.instanceId, this.volumeId);
        }

        public String toString() {
            return "ListVolumeAttachmentsRequest.Builder(compartmentId=" + this.compartmentId + ", availabilityDomain=" + this.availabilityDomain + ", limit=" + this.limit + ", page=" + this.page + ", instanceId=" + this.instanceId + ", volumeId=" + this.volumeId + ")";
        }
    }
}

