/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListVolumeBackupPoliciesRequest
extends BmcRequest {
    private Integer limit;
    private String page;
    private String compartmentId;

    @ConstructorProperties(value={"limit", "page", "compartmentId"})
    ListVolumeBackupPoliciesRequest(Integer limit, String page, String compartmentId) {
        this.limit = limit;
        this.page = page;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder {
        private Integer limit;
        private String page;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListVolumeBackupPoliciesRequest o) {
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListVolumeBackupPoliciesRequest build() {
            ListVolumeBackupPoliciesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public ListVolumeBackupPoliciesRequest buildWithoutInvocationCallback() {
            return new ListVolumeBackupPoliciesRequest(this.limit, this.page, this.compartmentId);
        }

        public String toString() {
            return "ListVolumeBackupPoliciesRequest.Builder(limit=" + this.limit + ", page=" + this.page + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

