/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.core.model.VolumeBackup;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListVolumeBackupsRequest
extends BmcRequest {
    private String compartmentId;
    private String volumeId;
    private Integer limit;
    private String page;
    private String displayName;
    private String sourceVolumeBackupId;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private VolumeBackup.LifecycleState lifecycleState;

    @ConstructorProperties(value={"compartmentId", "volumeId", "limit", "page", "displayName", "sourceVolumeBackupId", "sortBy", "sortOrder", "lifecycleState"})
    ListVolumeBackupsRequest(String compartmentId, String volumeId, Integer limit, String page, String displayName, String sourceVolumeBackupId, SortBy sortBy, SortOrder sortOrder, VolumeBackup.LifecycleState lifecycleState) {
        this.compartmentId = compartmentId;
        this.volumeId = volumeId;
        this.limit = limit;
        this.page = page;
        this.displayName = displayName;
        this.sourceVolumeBackupId = sourceVolumeBackupId;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSourceVolumeBackupId() {
        return this.sourceVolumeBackupId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public VolumeBackup.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder {
        private String compartmentId;
        private String volumeId;
        private Integer limit;
        private String page;
        private String displayName;
        private String sourceVolumeBackupId;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private VolumeBackup.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListVolumeBackupsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.volumeId(o.getVolumeId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.displayName(o.getDisplayName());
            this.sourceVolumeBackupId(o.getSourceVolumeBackupId());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListVolumeBackupsRequest build() {
            ListVolumeBackupsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder sourceVolumeBackupId(String sourceVolumeBackupId) {
            this.sourceVolumeBackupId = sourceVolumeBackupId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(VolumeBackup.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public ListVolumeBackupsRequest buildWithoutInvocationCallback() {
            return new ListVolumeBackupsRequest(this.compartmentId, this.volumeId, this.limit, this.page, this.displayName, this.sourceVolumeBackupId, this.sortBy, this.sortOrder, this.lifecycleState);
        }

        public String toString() {
            return "ListVolumeBackupsRequest.Builder(compartmentId=" + this.compartmentId + ", volumeId=" + this.volumeId + ", limit=" + this.limit + ", page=" + this.page + ", displayName=" + this.displayName + ", sourceVolumeBackupId=" + this.sourceVolumeBackupId + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

