/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class TerminateClusterNetworkRequest
extends BmcRequest {
    private String clusterNetworkId;
    private String ifMatch;

    @ConstructorProperties(value={"clusterNetworkId", "ifMatch"})
    TerminateClusterNetworkRequest(String clusterNetworkId, String ifMatch) {
        this.clusterNetworkId = clusterNetworkId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getClusterNetworkId() {
        return this.clusterNetworkId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String clusterNetworkId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TerminateClusterNetworkRequest o) {
            this.clusterNetworkId(o.getClusterNetworkId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TerminateClusterNetworkRequest build() {
            TerminateClusterNetworkRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder clusterNetworkId(String clusterNetworkId) {
            this.clusterNetworkId = clusterNetworkId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public TerminateClusterNetworkRequest buildWithoutInvocationCallback() {
            return new TerminateClusterNetworkRequest(this.clusterNetworkId, this.ifMatch);
        }

        public String toString() {
            return "TerminateClusterNetworkRequest.Builder(clusterNetworkId=" + this.clusterNetworkId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

