/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class TerminateInstanceRequest
extends BmcRequest {
    private String instanceId;
    private String ifMatch;
    private Boolean preserveBootVolume;

    @ConstructorProperties(value={"instanceId", "ifMatch", "preserveBootVolume"})
    TerminateInstanceRequest(String instanceId, String ifMatch, Boolean preserveBootVolume) {
        this.instanceId = instanceId;
        this.ifMatch = ifMatch;
        this.preserveBootVolume = preserveBootVolume;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Boolean getPreserveBootVolume() {
        return this.preserveBootVolume;
    }

    public static class Builder {
        private String instanceId;
        private String ifMatch;
        private Boolean preserveBootVolume;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(TerminateInstanceRequest o) {
            this.instanceId(o.getInstanceId());
            this.ifMatch(o.getIfMatch());
            this.preserveBootVolume(o.getPreserveBootVolume());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public TerminateInstanceRequest build() {
            TerminateInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder preserveBootVolume(Boolean preserveBootVolume) {
            this.preserveBootVolume = preserveBootVolume;
            return this;
        }

        public TerminateInstanceRequest buildWithoutInvocationCallback() {
            return new TerminateInstanceRequest(this.instanceId, this.ifMatch, this.preserveBootVolume);
        }

        public String toString() {
            return "TerminateInstanceRequest.Builder(instanceId=" + this.instanceId + ", ifMatch=" + this.ifMatch + ", preserveBootVolume=" + this.preserveBootVolume + ")";
        }
    }
}

