/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateBootVolumeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateBootVolumeRequest
extends BmcRequest {
    private String bootVolumeId;
    private UpdateBootVolumeDetails updateBootVolumeDetails;
    private String ifMatch;

    @ConstructorProperties(value={"bootVolumeId", "updateBootVolumeDetails", "ifMatch"})
    UpdateBootVolumeRequest(String bootVolumeId, UpdateBootVolumeDetails updateBootVolumeDetails, String ifMatch) {
        this.bootVolumeId = bootVolumeId;
        this.updateBootVolumeDetails = updateBootVolumeDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBootVolumeId() {
        return this.bootVolumeId;
    }

    public UpdateBootVolumeDetails getUpdateBootVolumeDetails() {
        return this.updateBootVolumeDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String bootVolumeId;
        private UpdateBootVolumeDetails updateBootVolumeDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateBootVolumeRequest o) {
            this.bootVolumeId(o.getBootVolumeId());
            this.updateBootVolumeDetails(o.getUpdateBootVolumeDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateBootVolumeRequest build() {
            UpdateBootVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder bootVolumeId(String bootVolumeId) {
            this.bootVolumeId = bootVolumeId;
            return this;
        }

        public Builder updateBootVolumeDetails(UpdateBootVolumeDetails updateBootVolumeDetails) {
            this.updateBootVolumeDetails = updateBootVolumeDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateBootVolumeRequest buildWithoutInvocationCallback() {
            return new UpdateBootVolumeRequest(this.bootVolumeId, this.updateBootVolumeDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateBootVolumeRequest.Builder(bootVolumeId=" + this.bootVolumeId + ", updateBootVolumeDetails=" + this.updateBootVolumeDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

