/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateClusterNetworkDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateClusterNetworkRequest
extends BmcRequest {
    private String clusterNetworkId;
    private UpdateClusterNetworkDetails updateClusterNetworkDetails;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"clusterNetworkId", "updateClusterNetworkDetails", "opcRetryToken", "ifMatch"})
    UpdateClusterNetworkRequest(String clusterNetworkId, UpdateClusterNetworkDetails updateClusterNetworkDetails, String opcRetryToken, String ifMatch) {
        this.clusterNetworkId = clusterNetworkId;
        this.updateClusterNetworkDetails = updateClusterNetworkDetails;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getClusterNetworkId() {
        return this.clusterNetworkId;
    }

    public UpdateClusterNetworkDetails getUpdateClusterNetworkDetails() {
        return this.updateClusterNetworkDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String clusterNetworkId;
        private UpdateClusterNetworkDetails updateClusterNetworkDetails;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateClusterNetworkRequest o) {
            this.clusterNetworkId(o.getClusterNetworkId());
            this.updateClusterNetworkDetails(o.getUpdateClusterNetworkDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateClusterNetworkRequest build() {
            UpdateClusterNetworkRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder clusterNetworkId(String clusterNetworkId) {
            this.clusterNetworkId = clusterNetworkId;
            return this;
        }

        public Builder updateClusterNetworkDetails(UpdateClusterNetworkDetails updateClusterNetworkDetails) {
            this.updateClusterNetworkDetails = updateClusterNetworkDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateClusterNetworkRequest buildWithoutInvocationCallback() {
            return new UpdateClusterNetworkRequest(this.clusterNetworkId, this.updateClusterNetworkDetails, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "UpdateClusterNetworkRequest.Builder(clusterNetworkId=" + this.clusterNetworkId + ", updateClusterNetworkDetails=" + this.updateClusterNetworkDetails + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

