/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateConsoleHistoryDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateConsoleHistoryRequest
extends BmcRequest {
    private String instanceConsoleHistoryId;
    private UpdateConsoleHistoryDetails updateConsoleHistoryDetails;
    private String ifMatch;

    @ConstructorProperties(value={"instanceConsoleHistoryId", "updateConsoleHistoryDetails", "ifMatch"})
    UpdateConsoleHistoryRequest(String instanceConsoleHistoryId, UpdateConsoleHistoryDetails updateConsoleHistoryDetails, String ifMatch) {
        this.instanceConsoleHistoryId = instanceConsoleHistoryId;
        this.updateConsoleHistoryDetails = updateConsoleHistoryDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceConsoleHistoryId() {
        return this.instanceConsoleHistoryId;
    }

    public UpdateConsoleHistoryDetails getUpdateConsoleHistoryDetails() {
        return this.updateConsoleHistoryDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String instanceConsoleHistoryId;
        private UpdateConsoleHistoryDetails updateConsoleHistoryDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateConsoleHistoryRequest o) {
            this.instanceConsoleHistoryId(o.getInstanceConsoleHistoryId());
            this.updateConsoleHistoryDetails(o.getUpdateConsoleHistoryDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateConsoleHistoryRequest build() {
            UpdateConsoleHistoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceConsoleHistoryId(String instanceConsoleHistoryId) {
            this.instanceConsoleHistoryId = instanceConsoleHistoryId;
            return this;
        }

        public Builder updateConsoleHistoryDetails(UpdateConsoleHistoryDetails updateConsoleHistoryDetails) {
            this.updateConsoleHistoryDetails = updateConsoleHistoryDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateConsoleHistoryRequest buildWithoutInvocationCallback() {
            return new UpdateConsoleHistoryRequest(this.instanceConsoleHistoryId, this.updateConsoleHistoryDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateConsoleHistoryRequest.Builder(instanceConsoleHistoryId=" + this.instanceConsoleHistoryId + ", updateConsoleHistoryDetails=" + this.updateConsoleHistoryDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

