/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateCpeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateCpeRequest
extends BmcRequest {
    private String cpeId;
    private UpdateCpeDetails updateCpeDetails;
    private String ifMatch;

    @ConstructorProperties(value={"cpeId", "updateCpeDetails", "ifMatch"})
    UpdateCpeRequest(String cpeId, UpdateCpeDetails updateCpeDetails, String ifMatch) {
        this.cpeId = cpeId;
        this.updateCpeDetails = updateCpeDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCpeId() {
        return this.cpeId;
    }

    public UpdateCpeDetails getUpdateCpeDetails() {
        return this.updateCpeDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String cpeId;
        private UpdateCpeDetails updateCpeDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateCpeRequest o) {
            this.cpeId(o.getCpeId());
            this.updateCpeDetails(o.getUpdateCpeDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateCpeRequest build() {
            UpdateCpeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder cpeId(String cpeId) {
            this.cpeId = cpeId;
            return this;
        }

        public Builder updateCpeDetails(UpdateCpeDetails updateCpeDetails) {
            this.updateCpeDetails = updateCpeDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateCpeRequest buildWithoutInvocationCallback() {
            return new UpdateCpeRequest(this.cpeId, this.updateCpeDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateCpeRequest.Builder(cpeId=" + this.cpeId + ", updateCpeDetails=" + this.updateCpeDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

