/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateCrossConnectDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateCrossConnectRequest
extends BmcRequest {
    private String crossConnectId;
    private UpdateCrossConnectDetails updateCrossConnectDetails;
    private String ifMatch;

    @ConstructorProperties(value={"crossConnectId", "updateCrossConnectDetails", "ifMatch"})
    UpdateCrossConnectRequest(String crossConnectId, UpdateCrossConnectDetails updateCrossConnectDetails, String ifMatch) {
        this.crossConnectId = crossConnectId;
        this.updateCrossConnectDetails = updateCrossConnectDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCrossConnectId() {
        return this.crossConnectId;
    }

    public UpdateCrossConnectDetails getUpdateCrossConnectDetails() {
        return this.updateCrossConnectDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String crossConnectId;
        private UpdateCrossConnectDetails updateCrossConnectDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateCrossConnectRequest o) {
            this.crossConnectId(o.getCrossConnectId());
            this.updateCrossConnectDetails(o.getUpdateCrossConnectDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateCrossConnectRequest build() {
            UpdateCrossConnectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder crossConnectId(String crossConnectId) {
            this.crossConnectId = crossConnectId;
            return this;
        }

        public Builder updateCrossConnectDetails(UpdateCrossConnectDetails updateCrossConnectDetails) {
            this.updateCrossConnectDetails = updateCrossConnectDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateCrossConnectRequest buildWithoutInvocationCallback() {
            return new UpdateCrossConnectRequest(this.crossConnectId, this.updateCrossConnectDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateCrossConnectRequest.Builder(crossConnectId=" + this.crossConnectId + ", updateCrossConnectDetails=" + this.updateCrossConnectDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

