/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.core.model.UpdateDhcpDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateDhcpOptionsRequest
extends BmcRequest {
    private String dhcpId;
    private UpdateDhcpDetails updateDhcpDetails;
    private String ifMatch;

    @ConstructorProperties(value={"dhcpId", "updateDhcpDetails", "ifMatch"})
    UpdateDhcpOptionsRequest(String dhcpId, UpdateDhcpDetails updateDhcpDetails, String ifMatch) {
        this.dhcpId = dhcpId;
        this.updateDhcpDetails = updateDhcpDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDhcpId() {
        return this.dhcpId;
    }

    public UpdateDhcpDetails getUpdateDhcpDetails() {
        return this.updateDhcpDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String dhcpId;
        private UpdateDhcpDetails updateDhcpDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDhcpOptionsRequest o) {
            this.dhcpId(o.getDhcpId());
            this.updateDhcpDetails(o.getUpdateDhcpDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDhcpOptionsRequest build() {
            UpdateDhcpOptionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dhcpId(String dhcpId) {
            this.dhcpId = dhcpId;
            return this;
        }

        public Builder updateDhcpDetails(UpdateDhcpDetails updateDhcpDetails) {
            this.updateDhcpDetails = updateDhcpDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateDhcpOptionsRequest buildWithoutInvocationCallback() {
            return new UpdateDhcpOptionsRequest(this.dhcpId, this.updateDhcpDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateDhcpOptionsRequest.Builder(dhcpId=" + this.dhcpId + ", updateDhcpDetails=" + this.updateDhcpDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

